﻿using System;
using System.Activities;
using System.Linq;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Workflow;
using VA.PPMS.Context;
using Microsoft.Crm.Sdk.Messages;


namespace VA.PPMS.Workflows.SharePoint
{
    public sealed class SharepointDocumentCreate : CodeActivity
    {
        protected override void Execute(CodeActivityContext executionContext)
        {
            //Create the tracing service
            ITracingService tracingService = executionContext.GetExtension<ITracingService>();

            //Create the context
            IWorkflowContext context = executionContext.GetExtension<IWorkflowContext>();
            IOrganizationServiceFactory serviceFactory = executionContext.GetExtension<IOrganizationServiceFactory>();
            IOrganizationService service = serviceFactory.CreateOrganizationService(context.UserId);

            tracingService.Trace("SharePoint Document Create");

            //Get the Provider Agreement Reference and Doc Loation Reference Inputs. 
            EntityReference providerAgreement = this.ProviderAgreement.Get(executionContext);
            EntityReference docLocation = this.DocumentLocation.Get(executionContext);
           
            if (providerAgreement != null && docLocation != null)
            {
                tracingService.Trace("Looking up Absolute URL");
                
                using (var svc = new PpmsContext(service))
                {
                    // Retrieve the absolute URL and the Site Collection URL
                    // of the SharePoint document location record.
                    RetrieveAbsoluteAndSiteCollectionUrlRequest retrieveRequest = new RetrieveAbsoluteAndSiteCollectionUrlRequest
                    {
                        Target = new EntityReference(SharePointDocumentLocation.EntityLogicalName, docLocation.Id)
                    };
                    RetrieveAbsoluteAndSiteCollectionUrlResponse retrieveResponse = (RetrieveAbsoluteAndSiteCollectionUrlResponse)service.Execute(retrieveRequest);

                    if (retrieveResponse != null)
                    {
                        string absoluteUrl = retrieveResponse.AbsoluteUrl.ToString();
                        if (absoluteUrl != String.Empty)
                        {
                            tracingService.Trace("SharePoint Folder Absolute Url Found: " + absoluteUrl);
                            var updateProviderAgreement = new ppms_provideragreement { };
                            updateProviderAgreement.Id = providerAgreement.Id;
                            updateProviderAgreement["ppms_sharepointdocumentlocation"] = absoluteUrl;
                            service.Update(updateProviderAgreement);
                            tracingService.Trace("Provider Agreement Updated with SharePoint Folder Url");
                        }
                    }
                }
            }
        }

        [ReferenceTarget("ppms_provideragreement")]
        [Input("Provider Agreement")]
        public InArgument<EntityReference> ProviderAgreement { get; set; }

        [ReferenceTarget("sharepointdocumentlocation")]
        [Input("Document Location")]
        public InArgument<EntityReference> DocumentLocation { get; set; }
    }
}
